#ifndef __PEPALIGNGA_H__
#define __PEPALIGNGA_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdlib.h>
#include "pepAlignDefs.h"

/* Piecewise Linear Function structure*/
typedef struct pepalign_PLF_type {
	double xpoints[MAX_BREAKPOINTS];
	double ypoints[MAX_BREAKPOINTS];
	int nof_points;
	double fitness;
} plf_type, *pplf_type;

/* Procedure that initialises the GA and related structures*/
void init_alignment(pplf_type plf_array, int size, double** data_points, int n_points);

/* Procedure that sorts the breakpoints in a plf_type in ascending order */
void sort_breakpoints(pplf_type plf);

/* Function that copies the content of one candidate to another */
void copy_candidate(pplf_type dst, pplf_type src);

/* Function that sorts the PLF array in descending order according to their fitness */
void sort_candidates(pplf_type plf_array, int size);

/* Function that runs a selection and crossover procedure on the srcarray */
void select_cross_over(pplf_type src_array, int size, double selection_ratio);

/* Function that detemines a suitable position for a crossover operation */
void perform_crossover(pplf_type child1, pplf_type child2, int pos);

/* Mutates the designated samples with a certain random distribution */
void mutate_samples(pplf_type src_array, int size, double selection_ratio);

/* Function that performs Genetic Algorithm alignment, and outputs progress to a file */
pplf_type run_ga_alignment(double** data_points, int n_points, double lc_sigma, char* output_base, double* x_max, double* y_max);

#ifdef __cplusplus
}
#endif

#endif