#ifndef __PEPALIGNFUNCTIONS_H__
#define __PEPALIGNFUNCTIONS_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "pepXMLStructures.h"
#include "mzXMLStructures.h"

/* Global constants */  


/* Peptide structure */
typedef struct pepalign_peptide_type {
	char* sequence;
	char* protein;
	double score;	
	double mz;
	double scan;
	double time;
} peptide_type;

/* structure for storing program parameters */
typedef struct pepalign_parameters
{
	/* input file names */
	char* mzxml_file;
	char* pepxml_file;

	/* Output file names */
	char* output_file_base;

	/* selection / filter input */
	int ms_start_scan;
	int ms_end_scan;
	int pep_start_scan;
	int pep_end_scan;
	
	double mmme;				/* max mass measurement error */
	double lc_sigma;			/* max std_dev error */

	char* score_name;			/* the name of the score parameter */
	double min_score_threshold;	/* min score filter */
	double max_score_threshold;	/* max score filter */
	
	int alignmode;				/* what alignmode to do: 0 = scan, 1 = time */
	
} parameters;


/* Function that filters the parameters from command line input */
parameters* pepalign_filter_parameters(int argc, char *argv[]);

/* Initialization routine for parameters struct */
void init_parameters(parameters* params);

/* Function that reads a pepxml file and returns an array of peptide_type. Also checks if the mode is supported */
peptide_type* read_peptides(pmsms_pipeline_analysis pepfile, parameters* params, int* pepnum);

/* Function that filters out double peptides, keeps the one with the best score */
void unify_peptide_array(peptide_type* peparray, int* arraylen, parameters* params);

/* Calculates the mass of a sequence */
double calculate_sequence_mass(char *sequence, pmodification_info mod_info);

/* Function that determines if the peptide should be processed or not */
int process_peptide(search_hit sh, parameters* params);

/* Function that retrieves the relavant (ion / dot) and expect score for the algorithm */
double get_relevant_scores(search_hit sh, parameters* params);

/* Function that performs alignment on the peptide file, given the selected peptides */
double** align_peptides(pmzxml_file mzxmlf, peptide_type* peparray, int arraylen, parameters* params, int* nofpoints);

// Caculates the LC-sigma parameter if it hasnt been set
double calc_lcsigma();

#ifdef __cplusplus
}
#endif

#endif
