#ifndef __MSHYBRIDFUNCTIONS_H__
#define __MSHYBRIDFUNCTIONS_H__

#include <stdlib.h>

/*check if the compiler is of C++*/
#ifdef __cplusplus
extern "C" {
#endif

// Container for the user-defined arguments
typedef struct msHybrid_Arg_Type {
	char* IT_input;
	char* FT_input;
	char* PLF_input;
	char* hybrid_output;	
	int scan_error;
	int ppme;
	int mode; // 0 = scan, 1 = time
} msHybridArguments;

// Definition of a PLF function piece
typedef struct PLF_Function_Type {
	double offset;
	double incline;
	double start_index;
	double end_index;
} PLF_Function;

// Container for muiltiple PLFs
typedef struct PLF_Function_Array {
	PLF_Function* function_array;
	int size;
} PLF_Array;

// Handles the user-defined inputs
msHybridArguments handleInputs(int argc, char* argv[]);

// Handles the PLF file and returns an array of PFL parts
PLF_Array handlePLF(char* PLF_file, int* mode);

// Returns the correct PLF_Function for the input
PLF_Function getPLF(double index, PLF_Array plfa, int* found);

// Calculates the value for the plf and the x-input
double calcPLFValue(double index, PLF_Function func);


/*check if the compiler is of C++ */
#ifdef __cplusplus
}
#endif

#endif