// msHybrid.cpp : Defines the entry point for the console application.
//
#include <math.h>
#include <float.h>
#include "mzXMLReader.h"
#include "mzXMLWriter.h"
#include "msHybridFunctions.h"


double max(double val1, double val2)
{
	if (val1 <= val2)
		return val2;
	return val1;

}// max


double min(double val1, double val2)
{
	if (val1 <= val2)
		return val1;
	return val2;

}// max


// rounds a double to an integer
int iround(float val) 
{
	return (int)(val + 0.5);
}// int

// Finds the scan number of the scan matching the supplied retention time */
int match_scan_rt(pmzxml_file ft_mzfile, double rt)
{
	int i, bottom, top;		// loopvar		
	
	bottom = 0;
	top = ft_mzfile->scan_num - 1;
	i = (top + bottom) / 2;

	while ((top - bottom) > 1) {
		if (ft_mzfile->scan_array[i]->attributes.retentionTime == rt) 
			return i+1;
		else if (ft_mzfile->scan_array[i]->attributes.retentionTime > rt) 
			top = i;
		else
			bottom = i;
		i = (top + bottom) / 2;
	}// while

	if ((rt - ft_mzfile->scan_array[i]->attributes.retentionTime) < (ft_mzfile->scan_array[i+1]->attributes.retentionTime - rt))
		return i+1;
	return (i+2);

}// int match_scan_rt(double rt)


// Searches for the maximum intensity in a peak of a certain 
double max_int_in_peaks(scan_peaks peaks, double precursormz, int ppme, double* matched_mzs)
{
	int i, bottom, top, j;		// loopvar		
	double ppmdiff, maxint = 0;
	int found = 0;
	
	bottom = 0;
	top = peaks.count - 1;
	i = (top + bottom) / 2;

	while (!found && (top - bottom) > 1) {
		ppmdiff = ((fabs(peaks.mzs[i] - precursormz))/precursormz)*1e6;
		 
		if (ppmdiff < ppme) {
			found = 1;
			maxint = peaks.intensities[i];
			*matched_mzs = peaks.mzs[i];
		}// if
		else {
			if (peaks.mzs[i] > precursormz) 
				top = i;
			else
				bottom = i;
			i = (top + bottom) / 2;
		}// else		
	}// while

	// Checking the boundaries
	if (!found) {
		ppmdiff = ((fabs(peaks.mzs[i] - precursormz))/precursormz)*1e6;
		if (ppmdiff < ppme) {
			found = 1;
			maxint = peaks.intensities[i];
			*matched_mzs = peaks.mzs[i];
		}// if
		else {
			ppmdiff = ((fabs(peaks.mzs[i+1] - precursormz))/precursormz)*1e6;
			if (ppmdiff < ppme) {
				found = 1;
				maxint = peaks.intensities[i+1];
				*matched_mzs = peaks.mzs[i+1];
			}// if
			else {
				*matched_mzs = -1;
				return 0.0;
			}
		}// else
	}// if

	// Handling all possibilities that have smaller mzs
	for (j=i-1; j>=0; j--) {
		if (((fabs(peaks.mzs[j] - precursormz))/precursormz)*1e6 < ppme) {
			if (peaks.intensities[j] > maxint) {
				maxint = peaks.intensities[j];
				*matched_mzs = peaks.mzs[j];
			}// if
		}// if
		else
			j = -1;
	}// for 

	// Handling all possibilities that have larger mzs
	for (j = i+1; j<peaks.count; j++) {
		if (((fabs(peaks.mzs[j] - precursormz))/precursormz)*1e6 < ppme) {
			if (peaks.intensities[j] > maxint) {
				maxint = peaks.intensities[j];
				*matched_mzs = peaks.mzs[j];
			}// if
		}// if
		else
			j = peaks.count;
	}// for

	return maxint;
}

int main(int argc, char* argv[])
{
	int i, j, found;
	int minscan, maxscan;
	double mapscan, maptime;
	msHybridArguments args;
	PLF_Array plfa;
	PLF_Function func;
	double precursormz, intens, maxintens, matchedmz, bestmz;
	pmzxml_file it_mzfile;
	pmzxml_file ft_mzfile;
	scan_peaks peaks;
			
	printf("Reading parameters... ");
	args = handleInputs(argc, argv);
	printf("done\nReading PLF...");
	plfa = handlePLF(args.PLF_input, &(args.mode));
	printf("done\nReading IT mzXML file...");
	it_mzfile = read_mzxml_file(args.IT_input, parentfile_flag|dataprocessing_flag, scan_precursor_flag);
	printf("done\nReading FT mzXML file...");
	ft_mzfile = read_mzxml_file(args.FT_input, 0, 0);
	printf("done\nEvaluating precursors...");

	/* Each precursor will be evaluated */
	for (i=0; i<it_mzfile->scan_num; i++) {
		if (i%99 == 0)
			printf("%i...", i+1);

		if (it_mzfile->scan_array[i]->attributes.msLvl < 2) {
			free(it_mzfile->scan_array[i]);
			it_mzfile->scan_array[i] = NULL;
			continue; 
		}

		
		/* Get the value and determine search ranges */
		precursormz = it_mzfile->scan_array[i]->precursor_array[0].value;

		/* Scan mode */
		if (args.mode == 0) {
			func = getPLF(i+1, plfa, &found);
			if (found == 0)
				continue;
			mapscan = max(1, iround(calcPLFValue(i+1, func)));
		}// if
		else {
			func = getPLF(it_mzfile->scan_array[i]->attributes.retentionTime, plfa, &found);
			if (found == 0)
				continue;
			maptime = calcPLFValue(it_mzfile->scan_array[i]->attributes.retentionTime, func);
			mapscan = match_scan_rt(ft_mzfile, maptime);
		}// else

		minscan = max(1, floor((double)((mapscan)-args.scan_error)));
		maxscan = min(ft_mzfile->scan_num, ceil((double)((mapscan)+args.scan_error)));
		maxintens = 0;
		
		for (j=minscan; j<=maxscan; j++) {
			if (!ft_mzfile->scan_array[j-1]->peaks->mzs || !ft_mzfile->scan_array[j-1]->peaks->intensities)
				peaks = load_scan_peaks(ft_mzfile, j);
			else				
				peaks = *(ft_mzfile->scan_array[j-1]->peaks);

			intens = max_int_in_peaks(peaks, precursormz, args.ppme, &matchedmz);
			if (intens > maxintens) {
				maxintens = intens;
				bestmz = matchedmz;
			}// if
		}// for

		if (maxintens > 0) {
			printf("Modifying precursor of scan %i from %.6f to %.6f.\n", i+1, it_mzfile->scan_array[i]->precursor_array[0].value,  bestmz);
			it_mzfile->scan_array[i]->precursor_array[0].value = bestmz; 			
		}
		// Alles van minscan - 1 tot 0 kan gewist worden. Zoeken tot de laatste gewiste entry gevonden wordt
		for (j=minscan-1; j>=1; j--) {
			if (ft_mzfile->scan_array[j-1]->peaks->intensities ||  ft_mzfile->scan_array[j-1]->peaks->mzs)
				unload_scan_peaks(ft_mzfile, j);
			else
				break;
		}// for					
	}// for	

	printf("done\nWriting hybrid mzXML file to destination %s...", args.hybrid_output);
	write_mzxml_file(it_mzfile, args.hybrid_output);
	printf("done\n");

	return 0;
}
